/*
 * Decompiled with CFR 0.152.
 */
package com.roguewave.chart.datamodels.v2_1;

import com.roguewave.chart.core.v2_1.DataModel;
import com.roguewave.chart.datamodels.v2_1.DataModelSupport;

public class DataAdaptor
extends DataModelSupport {
    int rows_;
    int columns_;
    String name_;
    String rowVariableName_;
    String columnVariableName_;
    String[] rowLabels_;
    String[] columnLabels_;
    double[] values_;
    double min_;
    double max_;
    boolean autoUpdate_ = false;

    public DataAdaptor(int rows, int columns) {
        this.rows_ = rows;
        this.columns_ = columns;
        this.name_ = "Data Set Name";
        this.rowVariableName_ = "Row Variable Name";
        this.columnVariableName_ = "Column Variable Name";
        this.rowLabels_ = new String[rows];
        for (int row = 0; row < rows; ++row) {
            this.rowLabels_[row] = String.valueOf("row ").concat(String.valueOf(row));
        }
        this.columnLabels_ = new String[columns];
        for (int column = 0; column < columns; ++column) {
            this.columnLabels_[column] = String.valueOf("column ").concat(String.valueOf(column));
        }
        this.values_ = new double[rows * columns];
        for (int i = 0; i < this.values_.length; ++i) {
            this.values_[i] = 0.0;
        }
        this.min_ = 0.0;
        this.max_ = 0.0;
    }

    public DataAdaptor(DataModel data) {
        this.copyData(data);
    }

    public void copyData(DataModel data) {
        this.rows_ = data.getRowCount();
        this.columns_ = data.getColumnCount();
        this.name_ = data.getName();
        this.rowVariableName_ = data.getRowVariableName();
        this.columnVariableName_ = data.getColumnVariableName();
        this.rowLabels_ = new String[this.rows_];
        for (int row = 0; row < this.rows_; ++row) {
            this.rowLabels_[row] = data.getRowLabel(row);
        }
        this.columnLabels_ = new String[this.columns_];
        for (int column = 0; column < this.columns_; ++column) {
            this.columnLabels_[column] = data.getColumnLabel(column);
        }
        this.values_ = new double[this.rows_ * this.columns_];
        this.min_ = this.max_ = data.getValue(0, 0);
        for (int row = 0; row < this.rows_; ++row) {
            for (int column = 0; column < this.columns_; ++column) {
                this.setValue(data.getValue(row, column), row, column);
            }
        }
        this.dataUpdate();
    }

    public boolean getAutoUpdate() {
        return this.autoUpdate_;
    }

    public void setAutoUpdate(boolean auto) {
        this.autoUpdate_ = auto;
    }

    public double getValue(int row, int column) {
        return this.values_[row * this.columns_ + column];
    }

    public void setValue(double value, int row, int column) {
        int index = row * this.columns_ + column;
        double old = this.values_[index];
        this.values_[index] = value;
        if (value < this.min_) {
            this.min_ = value;
        } else if (value > this.max_) {
            this.max_ = value;
        } else if (old == this.min_ || old == this.max_) {
            this.recalculateMinAndMax();
        }
        if (this.autoUpdate_) {
            this.dataUpdate();
        }
    }

    private void recalculateMinAndMax() {
        this.min_ = this.max_ = this.values_[0];
        for (int i = 0; i < this.values_.length; ++i) {
            if (this.values_[i] < this.min_) {
                this.min_ = this.values_[i];
            }
            if (!(this.values_[i] > this.max_)) continue;
            this.max_ = this.values_[i];
        }
    }

    public String getName() {
        return this.name_;
    }

    public void setName(String name) {
        this.name_ = name;
        if (this.autoUpdate_) {
            this.dataUpdate();
        }
    }

    public String getRowVariableName() {
        return this.rowVariableName_;
    }

    public void setRowVariableName(String name) {
        this.rowVariableName_ = name;
        if (this.autoUpdate_) {
            this.dataUpdate();
        }
    }

    public String getColumnVariableName() {
        return this.columnVariableName_;
    }

    public void setColumnVariableName(String name) {
        this.columnVariableName_ = name;
        if (this.autoUpdate_) {
            this.dataUpdate();
        }
    }

    public String getRowLabel(int row) {
        return this.rowLabels_[row];
    }

    public void setRowLabel(String label, int row) {
        this.rowLabels_[row] = label;
        if (this.autoUpdate_) {
            this.dataUpdate();
        }
    }

    public String getColumnLabel(int column) {
        return this.columnLabels_[column];
    }

    public void setColumnLabel(String label, int column) {
        this.columnLabels_[column] = label;
        if (this.autoUpdate_) {
            this.dataUpdate();
        }
    }

    public int getColumnCount() {
        return this.columns_;
    }

    public int getRowCount() {
        return this.rows_;
    }

    public double getRangeLow() {
        return this.min_;
    }

    public double getRangeHigh() {
        if (this.min_ == this.max_) {
            return this.min_ + 1.0;
        }
        return this.max_;
    }
}

